### **Introduction to EAP**

- **Purpose**: Initially designed as an authentication framework for PPP (Point-to-Point Protocol) and later adopted for use in wired (802.3) and wireless (802.11) networks.
- **Specifications**:
    - Originally specified in **RFC 2284**, later replaced by **RFC 3748** and updated in **RFC 5247** and **RFC 8940**.
- **Key Characteristics**:
    - **Flexible Transport Protocol**: Carries arbitrary authentication information but is not an authentication method itself.
    - **Media-Independent**: Typically operates over data-link layers like PPP, 802.3 (wired), or 802.11 (wireless).

---

### **EAP Packet Types**

Defined in **RFC 3748**, EAP packets are categorized based on the **Code Field**:

|**Code Field**|**EAP Packet Type**|
|---|---|
|1|Request|
|2|Response|
|3|Success|
|4|Failure|

- **Important Note**:
    - EAP is a **transport specification**, not an authentication protocol.

---

### **802.1X and EAP Encapsulation (EAPOL)**

- **802.1X**: Defines how EAP is encapsulated over IEEE 802 networks, known as **EAP over LAN (EAPOL)**.
- **Controlled Port**:
    - A port configured for **802.1X authentication**.
    - **Default Behavior**: Blocks all input except for EAPOL messages.
    - **After Authentication**: The supplicant gains access to network services once authenticated.

---

### **802.1X Authentication Process**

- **Generic Workflow**:
    
    - The supplicant (client) sends EAP messages.
    - The authenticator (switch or access point) enforces policies and translates Layer 2 EAPOL messages from the supplicant into Layer 3 RADIUS messages.
    - The authentication server (e.g., Cisco ISE) processes the authentication request and enforces policies.
- **Roles**:
    
    - **Supplicant**: Initiates authentication.
    - **Authenticator**: Acts as a policy enforcer and translator (EAPOL ↔ RADIUS).
    - **Authentication Server**: Validates credentials and provides authorization (e.g., Cisco ISE).

---

### **Key Takeaways**

- **EAP**: A transport protocol for authentication mechanisms, not an authentication method.
- **802.1X**: Provides the framework for authenticating devices using EAP over LAN (EAPOL).
- **Process**: Controlled ports enforce authentication before granting network access.